<?php
/* --------------------------------------------------------------
   Permission.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Permission;

/**
 * Interface Permission
 *
 * @package Gambio\Core\Permission
 */
interface Permission
{
    /**
     * Returns the user id.
     *
     * @return int
     */
    public function userId(): int;
    
    
    /**
     * Returns the type.
     *
     * @return string
     */
    public function type(): string;
    
    
    /**
     * Returns the identifier.
     *
     * @return string
     */
    public function identifier(): string;
    
    
    /**
     * Returns the action.
     *
     * @return string
     */
    public function action(): string;
    
    
    /**
     * Checks if is Granted.
     *
     * @return bool
     */
    public function isGranted(): bool;
}